#rem Garage Fan.bas
The garage has a 14" exhaust fan.It has a local 3-way manual switch.
up=on,center=off,down=auto
This is for the circuit board which controls the garage fan in Auto mode.
It is a thermostat with a pot to set the fan on temperature.
The fan operature gas the following constraints:
1. It will not start if the door is down.
2. Once started it will continue to run for a minimum time..
John Saunders 4/25/2020 more outputs
#endrem

#PICAXE 14M2

'Inputs
symbol Temp_Port		= B.5		'An LM335, reads 10 mv per degree Kelvin
symbol Door_switch	= pinC.3	'Opens when fron door is all the way down = 1, white LED off
symbol Setting_pot	= C.4		'Pot sets the desired temperature

'Outputs
symbol Outport		= B.0		'Serial Output
symbol Relay_Coil		= B.1		'12V relay runs the fan when 1 in auto position.
symbol Red_LED		= B.3		'1 IS LIT;denotes G_temp exceeds Setting
symbol Yellow_LED		= C.0		'1 IS LIT;Denotes fan is running on minimum time.
symbol Green_LED		= C.1		'1 IS LIT;denotes fan is running

'Variables
symbol tempAcc	= w10			   'Accumulate 18 LM335 readings
symbol analogCount      	= w11			'Remainder when calculating the ascill value
symbol G_temp		= b1
symbol Door_down		= bit0	'1 when down
symbol Old_Door_Down	= bit1
symbol degChange		= bit2
symbol fanRunning		= bit3
symbol degHot			= bit4
symbol Minutes		= b2
symbol Cycles		= b3
symbol Setting		= b4
symbol State		= b5		'0=Idle,Fan off,1=Door Open,Fan off,2=Hot,Fan off,3=Fan on,4:Fan on timeout
symbol old_State		= b6
symbol tempCount	= b7
symbol Old_temp	= b8

'Transmit variables
symbol ChckHex	      = b10
symbol Scratch	      = b11		
symbol ChckSum    	= b12
symbol t_temp		= b13


'Constants
symbol Setting_Base	= 49	'Added to setting pot to set its minimum temperature
symbol Timeout		= 4		'Minimum run time of 5 minutesin units of 1/2 second
symbol MinuteCount      = 12

Init:
SETFREQ m4
LOW Red_LED
LOW Yellow_LED
LOW Green_LED
LOW Relay_coil
LET Door_down = Door_switch
LET State = 0
LET Old_State=4
LET Cycles = 0
LET tempCount = 0
LET tempAcc = 0
LET Minutes = 0


Main:
IF tempCount < 18 THEN
	INC tempCount
	ADCCONFIG %011
	FVRSETUP  FVR4096
	READADC10 Temp_Port,analogCount
	LET tempAcc = tempAcc + analogCount
ELSE							'Temperature is ready to be calculated
	LET tempCount = 0
	LET tempAcc = tempAcc - 11491
	LET G_Temp = tempAcc/25
	LET tempAcc = 0
	ADCCONFIG 0
	READADC Setting_pot,Setting
	LET Setting = Setting/5 + Setting_Base
	IF G_Temp > Setting THEN
		LET degHot = 1
	ELSE
		LET degHot = 0
	ENDIF
'SERTXD ("Temperature = ",#G_temp," F, Setting = ",#Setting,13,10)
	INC Cycles
	IF Cycles >= MinuteCount OR Old_Door_Down = Door_Down THEN
'Once a minute processing
		LET Cycles = 0
		LET Scratch = 0
		LET degChange = 0
		LET Door_down = Door_switch
		IF Old_temp > G_temp THEN
			LET Scratch = Old_temp - G_temp
		ELSE
			LET Scratch = G_temp - Old_temp
		ENDIF
		IF  Scratch > 1 THEN
			LET Old_Temp = G_temp
			LET degChange = 1
		ENDIF
		SELECT State				'Action code
			CASE 0				'Idle
				LOW Red_LED
				LOW Yellow_LED
				LOW Green_LED
				LOW Relay_Coil
				LET fanRunning = 0
			CASE 1				'Door up
				LOW Relay_Coil
				LET fanRunning = 0
			CASE 2				'Hot
				LOW Relay_Coil
				LET fanRunning = 0
				HIGH Red_LED
			CASE 3				'Fan running
				LOW Red_LED
				LOW Yellow_LED
				HIGH Green_LED
				HIGH Relay_Coil
				LET fanRunning = 1
			CASE 4				'Timeout
				LOW Red_LED
				HIGH Yellow_LED
				LOW Green_LED
				HIGH Relay_Coil
				LET fanRunning = 1

		ENDSELECT

		SELECT State						'State machine code
			CASE 0						'Idle
				IF Door_Down = 0 THEN			'Up
					LET State = 1
				ELSEIF degHot = 1 THEN		'Hot
					LET State = 2
				ENDIF
			CASE 1						'door up, cold
				IF Door_Down = 1 THEN			'down
					LET State = 0
				ELSEIF degHot = 1 THEN		'Hot
					LET State = 3
				ENDIF
			CASE 2						'Hot, Door down
				IF degHot = 0  THEN		'Cold
					LET State = 0
				ELSEIF Door_Down = 0 THEN		'Up
					LET State = 3
				ENDIF
			CASE 3						'Running
				IF degHot = 0 OR Door_Down = 1 THEN						
					LET State = 4
					LET Minutes = 0
				ENDIF
			CASE 4
				IF Minutes < Timeout THEN
					INC Minutes
				ENDIF
				IF Minutes >= Timeout THEN					'Minimum cycle time
					LET State = 0
					LET Minutes = 0
				ELSEIF Door_Down = 0 AND degHot = 1 THEN	'Up and hot
					LET State = 3
				ENDIF
			ELSE
				LET State = 0
		ENDSELECT
		IF State <> Old_State OR Old_Door_Down <> Door_Down  OR degChange = 1 THEN
			GOSUB Transmit
		ENDIF
		LET Old_State = State
		LET Old_Door_Down = Door_Down
	ENDIF
ENDIF
PAUSE 175

GOTO main

Transmit:
rem Prepare the message
LET bptr = 28
LET Scratch  = G_temp/100		'Digit #1
LET Scratch  = Scratch + "0"		'Ascii
LET @bptrinc = Scratch			'28
LET t_temp    = G_temp//100		'Remainder for digit #2
LET Scratch  = t_temp/10			'Digit #2
LET Scratch  = Scratch + "0"		'Ascii
LET @bptrinc = Scratch			'29
LET Scratch  = t_temp//10		'Least significant digit
LET Scratch  = Scratch + "0"		'Ascii
LET @bptrinc = Scratch		     '30
LET @bptrinc = ","			     '31
IF Door_down = 0 THEN
	LET @bptrinc = "U"		'32
ELSE
	LET @bptrinc = "D"		'32
ENDIF
LET @bptrinc = ","			'33
IF degHot = 0 THEN
	LET @bptrinc = "C"		'34
ELSE
	LET @bptrinc = "H"		'34
ENDIF
LET @bptrinc = ","			'35
IF fanRunning = 0 THEN
	LET @bptrinc = "S"		'36
ELSE
	LET @bptrinc = "R"		'36
ENDIF

rem calculate the checksum and add to message
LET ChckSum = 0
FOR bptr = 28 TO 36
	LET ChckSum = ChckSum + @bptr 
NEXT

LET bptr = 37
LET @bptrinc = ","			'37
LET ChckHex = ChckSum / 16
IF ChckHex < 10 THEN
	LET ChckHex = ChckHex + "0"
ELSE
	LET ChckHex = ChckHex + "7"
ENDIF
LET @bptrinc = ChckHex			'38			'
LET ChckHex = ChckSum & $F
IF ChckHex < 10 THEN
	LET ChckHex = ChckHex + "0"
ELSE
	LET ChckHex = ChckHex + "7"
ENDIF
LET @bptr = ChckHex			'39

rem transmit by UHF radio with sync pulse, message type character (q) and message length code (I)
LET bptr = 28
HIGH Outport
PAUSE 20
LOW Outport
PAUSE 10
rem length char = ASCII of 60 + chars between and not including the bracketing end commas
rem                                                                            G_temp                 | comma  |   Door   | comma |    Hot  | comma |     Fan   | comma  |         ChckSum     |
rem                                                                 28           29            30            31            32            33           34          35            36           37          38             39           40          41             
SEROUT Outport, N2400_4,("14L1776u,E,",@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc,@bptrinc, @bptr,13,         10)

RETURN